<?php
// Create id attribute allowing for custom "anchor" value.
$id = $block['id'];
if (!empty($block['anchor'])) {
    $id = $block['anchor'];
}

// Create class attribute allowing for custom "className" and "align" values.
$className = '';
if (!empty($block['className'])) {
    $className .= ' ' . $block['className'];
}
if (have_rows('banner_section')):
    while (have_rows('banner_section')): the_row();
        $banner_bg_image = get_sub_field('banner_background_image');
        $banner_right_side_image = get_sub_field('banner_right_side_image');
        $banner_title = get_sub_field('title');
        $banner_banner_content = get_sub_field('banner_content');
        $button_name = get_sub_field('button_name');
        $page_url = get_sub_field('button_link');
        ?>
        <div id="<?php echo esc_attr($id); ?>" class="home-banner <?php echo esc_attr($className); ?>" <?php if ($banner_bg_image) { ?> style="background-image: url('<?php echo $banner_bg_image['url']; ?>')" <?php } ?>>                          
            <?php if ($banner_title || $banner_banner_content || $page_url) { ?> 
                <div class="container">
                    <div class="col-lg-6 col-md-6 banner-wrap">  
                        <div class="home-banner-info"> 
                            <?php if ($banner_title) { ?> 
                                <h1 class="banner-title"><?php echo $banner_title; ?></h1> 
                            <?php } ?>   
                            <?php if ($banner_banner_content) { ?> 
                                <div class="banner-content"><?php echo $banner_banner_content; ?></div> 
                            <?php } ?>
                            <?php if ($page_url) { ?> 
                                <div class="banner-btn mt-4">
                                    <a href="<?php echo $page_url; ?>" class="btn"> <?php echo $button_name; ?> </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>  
                </div>                    
            <?php } ?> 
            <?php if ($banner_right_side_image) { ?> 
            <img class="home-right-img" height="641" width="504" src="<?php echo $banner_right_side_image['url']; ?>" alt="<?php echo strip_tags($banner_title); ?>"> 
            <?php } ?> 
        </div> 
        <?php
    endwhile;
endif;
?>