function im_acf_init() {
if( function_exists('acf_register_block') ) {
acf_register_block(array(
            'name' => 'page-banner',
            'title' => __('Page Banner'),
            'description' => __('A custom page banner block.'),
            'render_callback' => 'im_acf_block_render_callback',
            //'category'			=> 'formatting',
            'category' => 'tms-common-blocks',
            'icon' => 'star-empty',
            'mode' => 'preview',
            'supports' => [
                'align' => false,
                'anchor' => true,
                'customClassName' => true,
                'jsx' => true,
            ],
        ));
			}
}

function im_acf_block_render_callback( $block ) {
    $slug = str_replace('acf/', '', $block['name']);

    if( file_exists( get_theme_file_path("/modules/content-{$slug}.php") ) ) {
		include( get_theme_file_path("/modules/content-{$slug}.php") );
	}
}